package game;

import java.io.IOException;

import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class CycleClip {
	
	private static final int MAX_CLIPS = 6;
	private Clip myCopiesOfClip[] = null;
	private int myCurrentIndex;
	
	public CycleClip(String fileName, AudioManager am) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
		
		myCopiesOfClip = new Clip[MAX_CLIPS];
		myCurrentIndex = 0;
		
		for(int i = 0; i < MAX_CLIPS; i++) {
			myCopiesOfClip[i] = am.loadGivenClip(fileName);
		}
		
	}
	
	public void play() {
		
		Clip clip = myCopiesOfClip[myCurrentIndex];
		myCurrentIndex = (myCurrentIndex + 1) % MAX_CLIPS;
		
		if(clip != null) {
			
			clip.setFramePosition(0);
			clip.start();
			
		}
		
	}
	
	
	public CycleClip(String fileName, int dummy, AudioManager am) {
		
		myCopiesOfClip = new Clip[MAX_CLIPS];
		myCurrentIndex = 0;
		
		for(int i = 0; i < MAX_CLIPS; i++) {
			myCopiesOfClip[i] = am.loadGivenClipViaURL(fileName);
		}
		
	}
	
	public void closeAllClips() {
		for(Clip clip : myCopiesOfClip) {
			clip.close();
		}
	}
	
}